import { errorBuilder, notImplementedErrorBuilder, successWithData, } from '../_router/dto/api-responses.dto.js';
import { MastoErrorHandler, MastojsHandler } from '../_router/_runner.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
import { Err, Ok } from '../../../utils/index.js';
export class MastodonAccountsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async lookup(webfinger) {
        try {
            const data = await this.client.lib.v1.accounts.lookup({
                acct: webfinger.host
                    ? `${webfinger.username}@${webfinger.host}`
                    : webfinger.username,
            });
            return Ok(data);
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async follow(id, opts) {
        const fn = this.client.lib.v1.accounts.$select(id).follow;
        return await MastojsHandler(await MastoErrorHandler(fn, [opts]));
    }
    async unfollow(id) {
        const fn = this.client.lib.v1.accounts.$select(id).unfollow;
        return await MastojsHandler(await MastoErrorHandler(fn));
    }
    async block(id) {
        const fn = this.client.lib.v1.accounts.$select(id).block;
        return await MastojsHandler(await MastoErrorHandler(fn));
    }
    async unblock(id) {
        const fn = this.client.lib.v1.accounts.$select(id).unblock;
        return await MastojsHandler(await MastoErrorHandler(fn));
    }
    async mute(id, opts) {
        const fn = this.client.lib.v1.accounts.$select(id).mute;
        return await MastojsHandler(await MastoErrorHandler(fn, [opts]));
    }
    async unmute(id) {
        const fn = this.client.lib.v1.accounts.$select(id).unmute;
        return await MastojsHandler(await MastoErrorHandler(fn));
    }
    async removeFollower(id) {
        const fn = this.client.lib.v1.accounts.$select(id).removeFromFollowers;
        return await MastojsHandler(await MastoErrorHandler(fn));
    }
    async featuredTags(id) {
        try {
            const fn = await this.client.lib.v1.accounts
                .$select(id)
                .featuredTags.list();
            return successWithData(fn);
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async familiarFollowers(ids) {
        const fn = this.client.lib.v1.accounts.familiarFollowers.fetch;
        return await MastojsHandler(await MastoErrorHandler(fn, [ids]));
    }
    lists(id) {
        throw new Error('Method not implemented.');
    }
    async statuses(id, query) {
        try {
            const data = await this.client.lib.v1.accounts
                .$select(id)
                .statuses.list(query);
            return Ok(data);
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async get(id) {
        const fn = this.client.lib.v1.accounts.$select(id).fetch;
        const { data, error } = await MastoErrorHandler(fn);
        const resData = await data;
        if (error || resData === undefined) {
            return errorBuilder(error);
        }
        return successWithData(data);
    }
    async getMany(ids) {
        return await new FetchWrapper(this.direct.baseUrl, this.direct.token).getCamelCase('/api/v1/accounts', { id: ids });
    }
    async relationships(ids) {
        const fn = this.client.lib.v1.accounts.relationships.fetch;
        const { data, error } = await MastoErrorHandler(fn, [{ id: ids }]);
        const resData = await data;
        if (error || resData === undefined) {
            return errorBuilder(error);
        }
        return successWithData(data);
    }
    async likes(query) {
        const { data: _data, error } = await this.direct.getCamelCaseWithLinkPagination('/api/v1/favourites', query);
        if (!_data || error) {
            return notImplementedErrorBuilder();
        }
        return {
            data: _data,
        };
    }
    async bookmarks(query) {
        const { data: _data, error } = await this.direct.getCamelCaseWithLinkPagination('/api/v1/bookmarks', query);
        if (!_data || error) {
            return notImplementedErrorBuilder();
        }
        return {
            data: _data,
        };
    }
    async followers(query) {
        try {
            const { id, ...rest } = query;
            const { data: _data, error } = await this.direct.getCamelCaseWithLinkPagination(`/api/v1/accounts/${id}/followers`, rest);
            if (error) {
                return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
            }
            return { data: _data };
        }
        catch (e) {
            console.log(e);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async followings(query) {
        try {
            const { id, ...rest } = query;
            const { data: _data, error } = await this.direct.getCamelCaseWithLinkPagination(`/api/v1/accounts/${id}/following`, rest);
            if (error) {
                return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
            }
            return { data: _data };
        }
        catch (e) {
            console.log(e);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
}
//# sourceMappingURL=accounts.js.map