import { AccountRoute } from '../_router/routes/_index.js';
import { AccountMutePostDto, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO } from '../_router/routes/accounts.js';
import { FollowPostDto, GetPostsQueryDTO } from '../_interface.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { LibraryPromise, PaginatedLibraryPromise } from '../_router/routes/_types.js';
import { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoList, MastoRelationship, MastoStatus } from '../../../types/mastojs.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { MastoJsWrapper } from '../../../custom-clients/custom-clients.js';
import { ApiAsyncResult } from '../../../utils/api-result.js';
import { DriverWebfingerType } from '../../../types/query.types.js';
export declare class MastodonAccountsRouter implements AccountRoute {
    direct: FetchWrapper;
    client: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    lookup(webfinger: DriverWebfingerType): ApiAsyncResult<MastoAccount>;
    follow(id: string, opts: FollowPostDto): Promise<LibraryResponse<MastoRelationship>>;
    unfollow(id: string): Promise<LibraryResponse<MastoRelationship>>;
    block(id: string): Promise<LibraryResponse<MastoRelationship>>;
    unblock(id: string): Promise<LibraryResponse<MastoRelationship>>;
    mute(id: string, opts: AccountMutePostDto): Promise<LibraryResponse<MastoRelationship>>;
    unmute(id: string): Promise<LibraryResponse<MastoRelationship>>;
    removeFollower(id: string): Promise<LibraryResponse<void>>;
    featuredTags(id: string): Promise<LibraryResponse<MastoFeaturedTag[]>>;
    familiarFollowers(ids: string[]): Promise<LibraryResponse<MastoFamiliarFollowers[]>>;
    lists(id: string): Promise<LibraryResponse<MastoList[]>>;
    statuses(id: string, query: AccountRouteStatusQueryDto): ApiAsyncResult<MastoStatus[]>;
    get(id: string): Promise<LibraryResponse<MastoAccount>>;
    getMany(ids: string[]): LibraryPromise<MastoAccount[]>;
    relationships(ids: string[]): Promise<LibraryResponse<MastoRelationship[]>>;
    likes(query: GetPostsQueryDTO): PaginatedLibraryPromise<MastoStatus[]>;
    bookmarks(query: BookmarkGetQueryDTO): Promise<LibraryResponse<{
        data: MastoStatus[];
        minId?: string | null;
        maxId?: string | null;
    }>>;
    followers(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    followings(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    }>;
}
//# sourceMappingURL=accounts.d.ts.map