import { MastodonInstanceRouter } from './instance.js';
import { MastodonAccountsRouter } from './accounts.js';
import { MastodonStatusesRouter } from './statuses.js';
import { MastodonTrendsRouter } from './trends.js';
import { MastodonNotificationsRouter } from './notifications.js';
import { MastodonTimelinesRouter } from './timelines.js';
import { MastodonTagRouter } from './tags.js';
import { MastodonSearchRouter } from './search.js';
import { MastodonMeRouter } from './me.js';
import { MastodonMediaRoute } from './media.js';
import { MastodonListRoute } from './lists.js';
import { MastodonProfileRouter } from './profile.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
class Adapter {
    driver;
    server;
    key;
    fetch;
    instances;
    accounts;
    statuses;
    trends;
    notifications;
    timelines;
    tags;
    search;
    me;
    media;
    lists;
    profile;
    post;
    user;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.fetch = FetchWrapper.create(dto.instance, dto.token);
        this.instances = new MastodonInstanceRouter(this.fetch);
        this.accounts = new MastodonAccountsRouter(this.fetch);
        this.statuses = new MastodonStatusesRouter(this.fetch);
        this.trends = new MastodonTrendsRouter(this.fetch);
        this.notifications = new MastodonNotificationsRouter(this.fetch);
        this.timelines = new MastodonTimelinesRouter(this.fetch);
        this.tags = new MastodonTagRouter(this.fetch);
        this.search = new MastodonSearchRouter(this.fetch);
        this.me = new MastodonMeRouter(this.fetch);
        this.media = new MastodonMediaRoute(this.fetch);
        this.lists = new MastodonListRoute(this.fetch);
        this.profile = new MastodonProfileRouter(this.fetch);
        this.post = new PostMutatorRoute(this);
        this.user = new UserRoute(this);
    }
}
export { Adapter as MastoApiAdapter };
//# sourceMappingURL=_router.js.map