import { RestClientCreateDTO } from '../_interface.js';
import { MastodonInstanceRouter } from './instance.js';
import { MastodonAccountsRouter } from './accounts.js';
import { MastodonStatusesRouter } from './statuses.js';
import { MastodonTrendsRouter } from './trends.js';
import { MastodonNotificationsRouter } from './notifications.js';
import { MastodonTimelinesRouter } from './timelines.js';
import { MastodonTagRouter } from './tags.js';
import { MastodonSearchRouter } from './search.js';
import { MastodonMeRouter } from './me.js';
import { MastodonMediaRoute } from './media.js';
import { MastodonListRoute } from './lists.js';
import { MastodonProfileRouter } from './profile.js';
import { ApiTargetInterface } from '../_router/routes/_index.js';
import FetchWrapper from '../../../custom-clients/custom-fetch.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
import { KNOWN_SOFTWARE } from '../../../data/driver.js';
declare class Adapter implements ApiTargetInterface {
    driver: KNOWN_SOFTWARE | string;
    server: string | null;
    key: string;
    fetch: FetchWrapper;
    instances: MastodonInstanceRouter;
    accounts: MastodonAccountsRouter;
    statuses: MastodonStatusesRouter;
    trends: MastodonTrendsRouter;
    notifications: MastodonNotificationsRouter;
    timelines: MastodonTimelinesRouter;
    tags: MastodonTagRouter;
    search: MastodonSearchRouter;
    me: MastodonMeRouter;
    media: MastodonMediaRoute;
    lists: MastodonListRoute;
    profile: MastodonProfileRouter;
    post: PostMutatorRoute;
    user: UserRoute;
    constructor(driver: KNOWN_SOFTWARE | string, server: string | null, dto: RestClientCreateDTO);
}
export { Adapter as MastoApiAdapter };
//# sourceMappingURL=_router.d.ts.map