import { notImplementedErrorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { Err } from '../../../utils/index.js';
export class DefaultStatusesRouter {
    async get(id) {
        return {
            error: {
                code: ApiErrorCode.FEATURE_UNSUPPORTED,
            },
        };
    }
    async create(dto) {
        return notImplementedErrorBuilder();
    }
    async delete(id) {
        return { success: false, deleted: false };
    }
    async bookmark(id) {
        return Err(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async unBookmark(id) {
        return Err(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async like(id) {
        return Err(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async removeLike(id) {
        return Err(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async getContext(id) {
        return notImplementedErrorBuilder();
    }
}
//# sourceMappingURL=statuses.js.map