import { DhaagaJsPostCreateDto, StatusesRoute } from '../_router/routes/statuses.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MastoContext, MastoScheduledStatus, MastoStatus } from '../../../types/mastojs.types.js';
import { MissContext } from '../../../types/misskey-js.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '../../../types/driver.types.js';
export declare class DefaultStatusesRouter implements StatusesRoute {
    get(id: string): Promise<LibraryResponse<MastoStatus>>;
    create(dto: DhaagaJsPostCreateDto): LibraryPromise<MastoScheduledStatus>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    getContext(id: string): LibraryPromise<MastoContext | MissContext>;
}
//# sourceMappingURL=statuses.d.ts.map