import { InstanceApi_CustomEmojiDTO, InstanceRoute } from '../_router/routes/instance.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MastoAccountCredentials } from '../../../types/mastojs.types.js';
import { ApiErrorCode, LibraryResponse } from '../../../types/result.types.js';
export declare class DefaultInstanceRouter implements InstanceRoute {
    private misskeyAuthUrl;
    getLoginUrl(urlLike: string, { uuid, appName, appCallback, appClientId, appClientSecret }: {
        appName: string;
        appCallback: string;
        appClientId?: string;
        uuid: string;
        appClientSecret?: string;
    }): LibraryPromise<{
        software: string;
        version?: string | null;
        loginUrl: string;
        loginStrategy: 'code' | 'miauth';
        clientId?: string;
        clientSecret?: string;
    }>;
    getCustomEmojis(urlLike: string, software?: string): Promise<LibraryResponse<InstanceApi_CustomEmojiDTO[]>>;
    getNodeInfo(urlLike: string): LibraryPromise<string>;
    private static getVersion;
    getSoftware(nodeinfoUrl: string): LibraryPromise<{
        software: string;
        version: string | null;
    }>;
    getSoftwareInfo(urlLike: string): Promise<{
        error: import("../../../types/result.types.js").ApiErrorComponent;
        data?: undefined;
    } | {
        error?: undefined;
        data: import("../_router/routes/instance.js").InstanceApi_SoftwareInfoDTO;
    }>;
    getTranslation(id: string, lang: string): Promise<{
        error: {
            code: ApiErrorCode;
        };
    }>;
    getMastodonAccessToken(instanceUrl: string, code: string, clientId: string, clientSecret: string): Promise<any>;
    verifyCredentials(urlLike: string, token: string): LibraryPromise<MastoAccountCredentials>;
}
//# sourceMappingURL=instance.d.ts.map