import { notImplementedErrorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { Err } from '../../../utils/index.js';
export class BaseAccountsRouter {
    async lookup(webfinger) {
        throw new Error('Method not implemented.');
    }
    follow(id, opts) {
        throw new Error('Method not implemented.');
    }
    unfollow(id) {
        throw new Error('Method not implemented.');
    }
    block(id) {
        throw new Error('Method not implemented.');
    }
    unblock(id) {
        throw new Error('Method not implemented.');
    }
    mute(id, opts) {
        throw new Error('Method not implemented.');
    }
    unmute(id) {
        throw new Error('Method not implemented.');
    }
    removeFollower(id) {
        throw new Error('Method not implemented.');
    }
    featuredTags(id) {
        throw new Error('Method not implemented.');
    }
    familiarFollowers(ids) {
        throw new Error('Method not implemented.');
    }
    lists(id) {
        throw new Error('Method not implemented.');
    }
    async get(id) {
        return {
            error: {
                code: ApiErrorCode.FEATURE_UNSUPPORTED,
            },
        };
    }
    async getMany(ids) {
        return notImplementedErrorBuilder();
    }
    async statuses(id, query) {
        return Err(ApiErrorCode.INCOMPATIBLE_DRIVER);
    }
    async relationships(ids) {
        return notImplementedErrorBuilder();
    }
    async likes(opts) {
        return notImplementedErrorBuilder();
    }
    async bookmarks(query) {
        return notImplementedErrorBuilder();
    }
    async followers(query) {
        throw new Error('Method not implemented.');
    }
    async followings(query) {
        throw new Error('Method not implemented.');
    }
}
export class DefaultAccountRouter extends BaseAccountsRouter {
}
//# sourceMappingURL=accounts.js.map