import { AccountMutePostDto, AccountRoute, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO } from '../_router/routes/accounts.js';
import { FollowPostDto, GetPostsQueryDTO } from '../_interface.js';
import { LibraryPromise, PaginatedLibraryPromise } from '../_router/routes/_types.js';
import { Endpoints } from 'misskey-js';
import { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoList, MastoRelationship, MastoStatus } from '../../../types/mastojs.types.js';
import { MegaAccount, MegaRelationship, MegaStatus } from '../../../types/megalodon.types.js';
import { MissUserDetailed } from '../../../types/misskey-js.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { ApiAsyncResult } from '../../../utils/api-result.js';
import { DriverWebfingerType } from '../../../types/query.types.js';
export declare abstract class BaseAccountsRouter implements AccountRoute {
    lookup(webfinger: DriverWebfingerType): ApiAsyncResult<MastoAccount | MegaAccount>;
    follow(id: string, opts: FollowPostDto): LibraryPromise<MastoRelationship | Endpoints['following/create']['res'] | MegaRelationship>;
    unfollow(id: string): LibraryPromise<MastoRelationship | Endpoints['following/delete']['res'] | MegaRelationship>;
    block(id: string): LibraryPromise<MastoRelationship | Endpoints['blocking/create']['res'] | MegaRelationship>;
    unblock(id: string): LibraryPromise<MastoRelationship | Endpoints['blocking/delete']['res'] | MegaRelationship>;
    mute(id: string, opts: AccountMutePostDto): Promise<LibraryResponse<MastoRelationship>>;
    unmute(id: string): Promise<LibraryResponse<MastoRelationship | MegaRelationship>>;
    removeFollower(id: string): Promise<LibraryResponse<void>>;
    featuredTags(id: string): Promise<LibraryResponse<MastoFeaturedTag[]>>;
    familiarFollowers(ids: string[]): Promise<LibraryResponse<MastoFamiliarFollowers[]>>;
    lists(id: string): Promise<LibraryResponse<MastoList[]>>;
    get(id: string): Promise<LibraryResponse<MastoAccount | MissUserDetailed | MegaAccount>>;
    getMany(ids: string[]): LibraryPromise<MastoAccount[] | MissUserDetailed[]>;
    statuses(id: string, query: AccountRouteStatusQueryDto): ApiAsyncResult<MastoStatus[]>;
    relationships(ids: string[]): Promise<LibraryResponse<MastoRelationship[] | MegaRelationship[]>>;
    likes(opts: GetPostsQueryDTO): PaginatedLibraryPromise<MastoStatus[] | MegaStatus[]>;
    bookmarks(query: BookmarkGetQueryDTO): LibraryPromise<{
        data: MastoStatus[] | Endpoints['i/favorites']['res'] | MegaStatus[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    followers(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    } | {
        data: Endpoints['users/followers']['res'];
        minId?: string | null;
        maxId?: string | null;
    }>;
    followings(query: FollowerGetQueryDTO): LibraryPromise<{
        data: MastoAccount[];
        minId?: string | null;
        maxId?: string | null;
    } | {
        data: Endpoints['users/followers']['res'];
        minId?: string | null;
        maxId?: string | null;
    }>;
}
export declare class DefaultAccountRouter extends BaseAccountsRouter {
}
//# sourceMappingURL=accounts.d.ts.map