import { DefaultInstanceRouter } from './instance.js';
import { DefaultAccountRouter } from './accounts.js';
import { DefaultStatusesRouter } from './statuses.js';
import { DefaultTrendsRouter } from './trends.js';
import { DefaultNotificationsRouter } from './notifications.js';
import { DefaultTimelinesRouter } from './timelines.js';
import { DefaultTagRouter } from './tags.js';
import { DefaultSearchRouter } from './search.js';
import { DefaultMeRouter } from './me.js';
import { DefaultMediaRoute } from './media.js';
import { DefaultListRoute } from './lists.js';
import { DefaultProfileRouter } from './profile.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
import { KNOWN_SOFTWARE } from '../../../data/driver.js';
class Adapter {
    driver;
    server;
    key;
    instances;
    accounts;
    statuses;
    trends;
    notifications;
    timelines;
    tags;
    search;
    me;
    media;
    lists;
    profile;
    post;
    user;
    constructor() {
        this.driver = KNOWN_SOFTWARE.UNKNOWN;
        this.server = null;
        this.key = 'N/A';
        this.instances = new DefaultInstanceRouter();
        this.accounts = new DefaultAccountRouter();
        this.statuses = new DefaultStatusesRouter();
        this.trends = new DefaultTrendsRouter();
        this.notifications = new DefaultNotificationsRouter();
        this.timelines = new DefaultTimelinesRouter();
        this.tags = new DefaultTagRouter();
        this.search = new DefaultSearchRouter();
        this.me = new DefaultMeRouter();
        this.media = new DefaultMediaRoute();
        this.lists = new DefaultListRoute();
        this.profile = new DefaultProfileRouter();
        this.post = new PostMutatorRoute(this);
        this.user = new UserRoute(this);
    }
}
export { Adapter as BaseApiAdapter };
//# sourceMappingURL=_router.js.map