import { ApiTargetInterface } from '../_router/routes/_index.js';
import { DefaultInstanceRouter } from './instance.js';
import { DefaultAccountRouter } from './accounts.js';
import { DefaultStatusesRouter } from './statuses.js';
import { DefaultTrendsRouter } from './trends.js';
import { DefaultNotificationsRouter } from './notifications.js';
import { DefaultTimelinesRouter } from './timelines.js';
import { DefaultTagRouter } from './tags.js';
import { DefaultSearchRouter } from './search.js';
import { DefaultMeRouter } from './me.js';
import { DefaultMediaRoute } from './media.js';
import { DefaultListRoute } from './lists.js';
import { DefaultProfileRouter } from './profile.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
import { KNOWN_SOFTWARE } from '../../../data/driver.js';
declare class Adapter implements ApiTargetInterface {
    driver: KNOWN_SOFTWARE | string;
    server: string | null;
    key: string;
    instances: DefaultInstanceRouter;
    accounts: DefaultAccountRouter;
    statuses: DefaultStatusesRouter;
    trends: DefaultTrendsRouter;
    notifications: DefaultNotificationsRouter;
    timelines: DefaultTimelinesRouter;
    tags: DefaultTagRouter;
    search: DefaultSearchRouter;
    me: DefaultMeRouter;
    media: DefaultMediaRoute;
    lists: DefaultListRoute;
    profile: DefaultProfileRouter;
    post: PostMutatorRoute;
    user: UserRoute;
    constructor();
}
export { Adapter as BaseApiAdapter };
//# sourceMappingURL=_router.d.ts.map