import { InvokeBskyFunction, InvokeBskyFunction_Improved, } from '../../../custom-clients/custom-bsky-agent.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { getBskyAgent, getXrpcAgent } from '../../../utils/atproto.js';
class BlueskyTimelinesRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    async hashtag(q, query) {
        const agent = getBskyAgent(this.dto);
        return InvokeBskyFunction_Improved('searchPosts', agent.app.bsky.feed.searchPosts, agent.app.bsky.feed, {
            q: q,
            limit: 10,
            cursor: query.maxId === null ? undefined : query.maxId,
        });
    }
    hashtagAsGuest(urlLike, q, query) {
        return Promise.resolve(undefined);
    }
    async home(query) {
        const agent = getBskyAgent(this.dto);
        try {
            return await agent.getTimeline({
                limit: query.limit || 10,
                cursor: query.maxId === null ? undefined : query.maxId,
                algorithm: 'reverse-chronological',
            });
        }
        catch (e) {
            console.log('[ERROR]: bluesky', e);
            throw new Error(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    list(q, query) {
        return Promise.resolve(undefined);
    }
    public(query) {
        return Promise.resolve(undefined);
    }
    publicAsGuest(urlLike, query) {
        return Promise.resolve(undefined);
    }
    async feed(params) {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('getFeed', agent.app.bsky.feed.getFeed, agent.app.bsky.feed, params);
    }
    async getFeedGenerator(uri) {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('getFeedGenerator', agent.app.bsky.feed.getFeedGenerator, agent.app.bsky.feed, {
            feed: uri,
        });
    }
    async getFeedGenerators(uriList) {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('getFeedGenerator', agent.app.bsky.feed.getFeedGenerators, agent.app.bsky.feed, {
            feed: uriList,
        });
    }
}
export default BlueskyTimelinesRouter;
//# sourceMappingURL=timelines.js.map