import { DriverTimelineGetApiResponse, DhaagaJsTimelineQueryOptions, TimelinesRoute } from '../_router/routes/timelines.js';
import { AppBskyFeedGetFeed, AppBskyFeedGetFeedGenerator, AppBskyFeedGetFeedGenerators, AppBskyFeedGetTimeline, AppBskyFeedSearchPosts } from '@atproto/api';
import { AppAtpSessionData } from '../../../types/atproto.js';
type FeedGetQueryDto = {
    feed: string;
    limit?: number;
    cursor?: string;
};
declare class BlueskyTimelinesRouter implements TimelinesRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    hashtag(q: string, query: DhaagaJsTimelineQueryOptions): Promise<AppBskyFeedSearchPosts.OutputSchema>;
    hashtagAsGuest(urlLike: string, q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    home(query: DhaagaJsTimelineQueryOptions): Promise<AppBskyFeedGetTimeline.Response>;
    list(q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    public(query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    publicAsGuest(urlLike: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    feed(params: FeedGetQueryDto): Promise<import("../../../types/result.types.js").LibraryResponse<AppBskyFeedGetFeed.OutputSchema>>;
    getFeedGenerator(uri: string): Promise<import("../../../types/result.types.js").LibraryResponse<AppBskyFeedGetFeedGenerator.OutputSchema>>;
    getFeedGenerators(uriList: string[]): Promise<import("../../../types/result.types.js").LibraryResponse<AppBskyFeedGetFeedGenerators.OutputSchema>>;
}
export default BlueskyTimelinesRouter;
//# sourceMappingURL=timelines.d.ts.map