import { DhaagaJsPostCreateDto, StatusesRoute } from '../_router/routes/statuses.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { AppBskyFeedGetPostThread, AtpSessionData, ChatBskyConvoGetConvo, ChatBskyConvoGetConvoForMembers, ChatBskyConvoSendMessage } from '@atproto/api';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '../../../types/driver.types.js';
declare class BlueskyStatusesRouter implements StatusesRoute {
    dto: AtpSessionData;
    constructor(dto: AtpSessionData);
    bookmark(id: string): DriverBookmarkStateResult;
    create(dto: DhaagaJsPostCreateDto): LibraryPromise<{
        uri: string;
        cid: string;
    }>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    get(id: string): LibraryPromise<AppBskyFeedGetPostThread.Response>;
    getContext(id: string, limit?: number): LibraryPromise<AppBskyFeedGetPostThread.Response>;
    like(uri: string, cid?: string): DriverLikeStateResult;
    removeLike(uri: string, cid?: string): DriverLikeStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    getConvoForMembers(members: string[]): LibraryPromise<ChatBskyConvoGetConvoForMembers.Response>;
    getConvo(id: string): LibraryPromise<ChatBskyConvoGetConvo.Response>;
    sendMessage(id: string, msg: string): LibraryPromise<ChatBskyConvoSendMessage.Response>;
    atProtoLike(uri: string, cid: string): DriverLikeStateResult;
    atProtoDeleteLike(uri: string): DriverLikeStateResult;
    atProtoRepost(uri: string, cid: string): Promise<{
        success: boolean;
        liked?: boolean;
        uri?: string;
    }>;
    atProtoDeleteRepost(uri: string): Promise<{
        success: boolean;
        liked: boolean;
    } | {
        liked?: undefined;
        success: boolean;
    }>;
}
export default BlueskyStatusesRouter;
//# sourceMappingURL=statuses.d.ts.map