import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { InvokeBskyFunction } from '../../../custom-clients/custom-bsky-agent.js';
import { getBskyAgent, getXrpcAgent } from '../../../utils/atproto.js';
class BlueskySearchRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    async findPosts(q) {
        try {
            const agent = getBskyAgent(this.dto);
            const data = await agent.app.bsky.feed.searchPosts({
                q: q.q,
                limit: 10,
                sort: q.sort,
                cursor: q.maxId === null ? undefined : q.maxId,
            });
            if (!data.success)
                return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
            return { data };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async findUsers(q) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.app.bsky.actor.searchActorsTypeahead({
            q: q.q,
            limit: q.limit || 8,
        });
        return { data };
    }
    async findFeeds(query) {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('getPopularFeedGenerators', agent.app.bsky.unspecced.getPopularFeedGenerators, agent.app.bsky.unspecced, query);
    }
}
export default BlueskySearchRouter;
//# sourceMappingURL=search.js.map