import { InvokeBskyFunction } from '../../../custom-clients/custom-bsky-agent.js';
import { getBskyAgent, getXrpcAgent } from '../../../utils/atproto.js';
class BlueskyNotificationsRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    get(query) {
        const agent = getXrpcAgent(this.dto);
        agent.listNotifications();
        return Promise.resolve({ data: undefined });
    }
    async getChats() {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('listConvos', agent.chat.bsky.convo.listConvos, agent.chat.bsky.convo, {
            limit: 10,
        }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
    }
    async getChat(convoId) {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('getConvo', agent.chat.bsky.convo.getConvo, agent.chat.bsky.convo, {
            convoId,
        }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
    }
    async getMessages(convoId) {
        const agent = getXrpcAgent(this.dto);
        return InvokeBskyFunction('getMessages', agent.chat.bsky.convo.getMessages, agent.chat.bsky.convo, {
            convoId,
            limit: 60,
        }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
    }
    async getMentions() {
        const agent = getBskyAgent(this.dto);
        return await InvokeBskyFunction('listNotifications', agent.listNotifications, agent, {
            reasons: ['mention', 'reply', 'quote'],
            limit: 30,
        });
    }
    async sendMessage(convoId, content) {
        const agent = getXrpcAgent(this.dto);
        return await InvokeBskyFunction('sendMessage', agent.chat.bsky.convo.sendMessage, agent.chat.bsky.convo, {
            convoId,
            message: {
                text: content.text,
                facets: content.facets,
            },
        }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
    }
    async getSocialUpdates(query) {
        const agent = getBskyAgent(this.dto);
        const resp = await agent.listNotifications({
            reasons: ['like', 'follow', 'repost'],
        });
        return resp;
    }
}
export default BlueskyNotificationsRouter;
//# sourceMappingURL=notifications.js.map