import { NotificationGetQueryDto, NotificationsRoute } from '../_router/routes/notifications.js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { MastoNotification } from '../../../types/mastojs.types.js';
import { MegaNotification } from '../../../types/megalodon.types.js';
import type { AppBskyNotificationListNotifications, ChatBskyConvoGetConvo, ChatBskyConvoGetMessages, ChatBskyConvoListConvos, Facet, ChatBskyConvoDefs } from '@atproto/api';
import type { AppAtpSessionData } from '../../../types/atproto.js';
declare class BlueskyNotificationsRouter implements NotificationsRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    get(query: NotificationGetQueryDto): LibraryPromise<{
        data: MastoNotification[] | MegaNotification[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    getChats(): LibraryPromise<ChatBskyConvoListConvos.OutputSchema>;
    getChat(convoId: string): LibraryPromise<ChatBskyConvoGetConvo.OutputSchema>;
    getMessages(convoId: string): LibraryPromise<ChatBskyConvoGetMessages.OutputSchema>;
    getMentions(): LibraryPromise<AppBskyNotificationListNotifications.OutputSchema>;
    sendMessage(convoId: string, content: {
        text: string;
        facets?: Facet[];
    }): LibraryPromise<ChatBskyConvoDefs.MessageView>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<AppBskyNotificationListNotifications.Response>;
}
export default BlueskyNotificationsRouter;
//# sourceMappingURL=notifications.d.ts.map