import { Err, Ok } from '../../../utils/index.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { getBskyAgent, getXrpcAgent } from '../../../utils/atproto.js';
export class BlueskyMeRouter {
    dto;
    xrpc;
    constructor(dto) {
        this.dto = dto;
        this.xrpc = getXrpcAgent(this.dto);
    }
    async getMe() {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getProfile({ actor: this.dto.did });
        return { data };
    }
    async getPreferences() {
        try {
            const data = await this.xrpc.app.bsky.actor.getPreferences();
            if (!data.success)
                return Err(ApiErrorCode.REMOTE_SERVER_ERROR);
            return Ok(data.data);
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
}
//# sourceMappingURL=me.js.map