import { LibraryPromise } from '../_router/routes/_types.js';
import { InstanceApi_CustomEmojiDTO, InstanceApi_SoftwareInfoDTO, InstanceRoute } from '../_router/routes/instance.js';
import { LibraryResponse } from '../../../types/result.types.js';
export declare class BlueskyInstanceRouter implements InstanceRoute {
    getTranslation(id: string, lang: string): Promise<LibraryResponse<any>>;
    getSoftwareInfo(urlLike: string, software?: string | undefined): Promise<LibraryResponse<InstanceApi_SoftwareInfoDTO>>;
    getCustomEmojis(urlLike: string): Promise<LibraryResponse<InstanceApi_CustomEmojiDTO[]>>;
    getLoginUrl(urlLike: string, {}: {
        appName: string;
        appCallback: string;
        appClientId: string;
        appClientSecret: string;
        uuid: string;
    }): LibraryPromise<{
        software: string;
        version?: string | null | undefined;
        loginUrl: string;
        loginStrategy: 'code' | 'miauth';
    }>;
}
//# sourceMappingURL=instance.d.ts.map