import { AppAtpSessionData } from '../../../types/atproto.js';
import { AppBskyActorGetPreferences, AppBskyFeedDefs, AppBskyFeedGetFeedGenerator, AtpAgent } from '@atproto/api';
import type { ApiAsyncResult } from '../../../utils/api-result.js';
type SubscriptionUpdateResult = Promise<{
    success: boolean;
    subscribed: boolean;
}>;
type PinStatusUpdateResult = Promise<{
    success: boolean;
    pinned: boolean;
}>;
type AppSavedPrefDate = AppBskyActorGetPreferences.OutputSchema;
declare class BlueskyFeedRouter {
    dto: AppAtpSessionData;
    xrpc: AtpAgent;
    constructor(dto: AppAtpSessionData);
    private ensureUserPref;
    private findFeedPref;
    getFeedGenerator(uri: string): ApiAsyncResult<AppBskyFeedGetFeedGenerator.OutputSchema>;
    getFeedGenerators(uriList: string[]): ApiAsyncResult<AppBskyFeedDefs.GeneratorView[]>;
    like(uri: string): Promise<import("../../../types/result.types.js").LibraryResponse<unknown>>;
    removeLike(uri: string): Promise<import("../../../types/result.types.js").LibraryResponse<unknown>>;
    addSubscription(uri: string, cached?: AppSavedPrefDate): SubscriptionUpdateResult;
    removeSubscription(uri: string, cached?: AppSavedPrefDate): SubscriptionUpdateResult;
    pin(uri: string, cached?: AppSavedPrefDate): PinStatusUpdateResult;
    removePin(uri: string, cached?: AppSavedPrefDate): PinStatusUpdateResult;
}
export default BlueskyFeedRouter;
//# sourceMappingURL=feeds.d.ts.map