import { errorBuilder } from '../_router/dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
import { InvokeBskyFunction } from '../../../custom-clients/custom-bsky-agent.js';
import { Err, Ok } from '../../../utils/index.js';
import { getBskyAgent, getXrpcAgent } from '../../../utils/atproto.js';
class BlueskyAccountsRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    block(id) {
        return Promise.resolve(undefined);
    }
    bookmarks(query) {
        return Promise.resolve(undefined);
    }
    familiarFollowers(ids) {
        return Promise.resolve([]);
    }
    featuredTags(id) {
        return Promise.resolve([]);
    }
    async follow(id, opts) {
        try {
            const agent = getXrpcAgent(this.dto);
            const followResult = await agent.follow(id);
            return { data: null };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    async followers(query) {
        const agent = getBskyAgent(this.dto);
        try {
            const data = await agent.getFollowers({ actor: query.id });
            return { data };
        }
        catch (e) {
            return errorBuilder(e);
        }
    }
    async followings(query) {
        const agent = getBskyAgent(this.dto);
        try {
            const data = await agent.getFollows({ actor: query.id });
            return { data };
        }
        catch (e) {
            return errorBuilder(e);
        }
    }
    async get(did) {
        const agent = getBskyAgent(this.dto);
        try {
            const data = await agent.getProfile({ actor: did });
            return { data };
        }
        catch (e) {
            return errorBuilder(e);
        }
    }
    async getDid(handle) {
        const agent = getBskyAgent(this.dto);
        try {
            const data = await agent.resolveHandle({ handle });
            return { data };
        }
        catch (e) {
            console.log('[WARN]: failed to resolve handle', e);
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    getMany(ids) {
        return Promise.resolve(undefined);
    }
    likes(query) {
        return errorBuilder(ApiErrorCode.FEATURE_UNSUPPORTED);
    }
    async atProtoLikes(actor, { limit, cursor, }) {
        const agent = getBskyAgent(this.dto);
        return InvokeBskyFunction('getActorLikes', agent.getActorLikes, agent.app.bsky.feed, {
            actor,
            cursor,
            limit,
        });
    }
    lists(id) {
        return Promise.resolve([]);
    }
    lookup(webfinger) {
        return Promise.resolve(undefined);
    }
    mute(id, opts) {
        return Promise.resolve(undefined);
    }
    relationships(ids) {
        return Promise.resolve(undefined);
    }
    removeFollower(id) {
        return Promise.resolve(undefined);
    }
    async statuses(id, params) {
        const agent = getBskyAgent(this.dto);
        try {
            const data = await agent.getAuthorFeed({
                actor: id,
                filter: params.bskyFilter,
                limit: params.limit,
            });
            return Ok(data);
        }
        catch (e) {
            return Err(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    unblock(id) {
        return Promise.resolve(undefined);
    }
    async unfollow(id) {
        try {
            const agent = getXrpcAgent(this.dto);
            await agent.deleteFollow(id);
            return { data: null };
        }
        catch (e) {
            return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
        }
    }
    unmute(id) {
        return Promise.resolve(undefined);
    }
    async getPinnedPosts(did) {
        const agent = getXrpcAgent(this.dto);
        try {
            const data = await agent.getAuthorFeed({
                includePins: true,
                actor: did,
                limit: 10,
            });
            return data.data.feed.filter((o) => o.reason && o.reason.$type === 'app.bsky.feed.defs#reasonPin');
        }
        catch (e) {
            return [];
        }
    }
}
export default BlueskyAccountsRouter;
//# sourceMappingURL=accounts.js.map