import { AccountMutePostDto, AccountRoute, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO } from '../_router/routes/accounts.js';
import { FollowPostDto, GetPostsQueryDTO } from '../_interface.js';
import { Endpoints } from 'misskey-js';
import { LibraryPromise } from '../_router/routes/_types.js';
import { AppBskyActorGetProfile, AppBskyFeedGetActorLikes, AppBskyFeedGetAuthorFeed, AppBskyGraphGetFollowers, AppBskyGraphGetFollows, ComAtprotoIdentityResolveHandle } from '@atproto/api';
import { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoList, MastoRelationship, MastoStatus } from '../../../types/mastojs.types.js';
import { MegaRelationship, MegaStatus } from '../../../types/megalodon.types.js';
import { MissUserDetailed } from '../../../types/misskey-js.types.js';
import { LibraryResponse } from '../../../types/result.types.js';
import { AppAtpSessionData } from '../../../types/atproto.js';
import { FeedViewPost } from '@atproto/api/dist/client/types/app/bsky/feed/defs.js';
import { ApiAsyncResult } from '../../../utils/api-result.js';
import { DriverWebfingerType } from '../../../types/query.types.js';
declare class BlueskyAccountsRouter implements AccountRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    block(id: string): Promise<LibraryResponse<MastoRelationship | Endpoints['blocking/create']['res'] | MegaRelationship>>;
    bookmarks(query: BookmarkGetQueryDTO): Promise<LibraryResponse<{
        data: MastoStatus[] | MegaStatus[] | Endpoints['i/favorites']['res'];
        minId?: string | null;
        maxId?: string | null;
    }>>;
    familiarFollowers(ids: string[]): LibraryPromise<MastoFamiliarFollowers[]>;
    featuredTags(id: string): LibraryPromise<MastoFeaturedTag[]>;
    follow(id: string, opts: FollowPostDto): LibraryPromise<MastoRelationship | Endpoints['following/create']['res'] | MegaRelationship>;
    followers(query: FollowerGetQueryDTO): LibraryPromise<AppBskyGraphGetFollowers.Response>;
    followings(query: FollowerGetQueryDTO): LibraryPromise<AppBskyGraphGetFollows.Response>;
    get(did: string): LibraryPromise<AppBskyActorGetProfile.Response>;
    getDid(handle: string): LibraryPromise<ComAtprotoIdentityResolveHandle.Response>;
    getMany(ids: string[]): LibraryPromise<MastoAccount[] | MissUserDetailed[]>;
    likes(query: GetPostsQueryDTO): any;
    atProtoLikes(actor: string, { limit, cursor }: {
        limit: number;
        cursor: string | undefined;
    }): LibraryPromise<AppBskyFeedGetActorLikes.OutputSchema>;
    lists(id: string): LibraryPromise<MastoList[]>;
    lookup(webfinger: DriverWebfingerType): ApiAsyncResult<MastoAccount>;
    mute(id: string, opts: AccountMutePostDto): Promise<LibraryResponse<MastoRelationship | MegaRelationship>>;
    relationships(ids: string[]): LibraryPromise<MastoRelationship[] | MegaRelationship[]>;
    removeFollower(id: string): Promise<LibraryResponse<void>>;
    statuses(id: string, params: AccountRouteStatusQueryDto): ApiAsyncResult<AppBskyFeedGetAuthorFeed.Response>;
    unblock(id: string): Promise<LibraryResponse<MastoRelationship>>;
    unfollow(id: string): LibraryPromise<MastoRelationship>;
    unmute(id: string): Promise<LibraryResponse<MastoRelationship | MegaRelationship>>;
    getPinnedPosts(did: string): Promise<FeedViewPost[]>;
}
export default BlueskyAccountsRouter;
//# sourceMappingURL=accounts.d.ts.map