import BlueskyAccountsRouter from './accounts.js';
import { BlueskyInstanceRouter } from './instance.js';
import { BlueskyListRoute } from './lists.js';
import { BlueskyMeRouter } from './me.js';
import BlueskyMediaRouter from './media.js';
import BlueskyNotificationsRouter from './notifications.js';
import BlueskyProfileRouter from './profile.js';
import BlueskySearchRouter from './search.js';
import BlueskyStatusesRouter from './statuses.js';
import BlueskyTagsRouter from './tags.js';
import BlueskyTimelinesRouter from './timelines.js';
import BlueskyTrendsRouter from './trends.js';
import BlueskyFeedRouter from './feeds.js';
import { PostMutatorRoute } from '../_router/routes/post.js';
import { UserRoute } from '../_router/routes/user.js';
import { getXrpcAgent } from '../../../utils/atproto.js';
class Adapter {
    driver;
    server;
    key;
    accounts;
    instances;
    lists;
    me;
    media;
    notifications;
    profile;
    search;
    statuses;
    tags;
    timelines;
    trends;
    feeds;
    post;
    user;
    dto;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.dto = dto;
        this.accounts = new BlueskyAccountsRouter(this.dto);
        this.instances = new BlueskyInstanceRouter();
        this.lists = new BlueskyListRoute();
        this.me = new BlueskyMeRouter(this.dto);
        this.media = new BlueskyMediaRouter();
        this.notifications = new BlueskyNotificationsRouter(this.dto);
        this.profile = new BlueskyProfileRouter();
        this.search = new BlueskySearchRouter(this.dto);
        this.statuses = new BlueskyStatusesRouter(this.dto);
        this.tags = new BlueskyTagsRouter();
        this.timelines = new BlueskyTimelinesRouter(this.dto);
        this.trends = new BlueskyTrendsRouter();
        this.feeds = new BlueskyFeedRouter(this.dto);
        this.post = new PostMutatorRoute(this.dto);
        this.user = new UserRoute(this.dto);
    }
    getAgent() {
        return getXrpcAgent(this.dto);
    }
}
export { Adapter as AtprotoApiAdapter };
//# sourceMappingURL=_router.js.map