import { Endpoints } from 'misskey-js';
import { AppBskyFeedGetTimeline, AppBskyFeedSearchPosts } from '@atproto/api';
import { MastoStatus } from '../../../../types/mastojs.types.js';
import { MegaStatus } from '../../../../types/megalodon.types.js';
type __MisskeyTimelineOptions = {
    limit?: number;
    sinceId?: string;
    untilId?: string;
    sinceDate?: number;
    untilDate?: number;
    allowPartial?: boolean;
    includeMyRenotes?: boolean;
    includeRenotedMyNotes?: boolean;
    includeLocalRenotes?: boolean;
    withFiles?: boolean;
    withRenotes?: boolean;
    renote?: boolean;
    poll?: boolean;
    reply?: boolean;
};
export type DhaagaJsTimelineQueryOptions = {
    limit: number;
    sinceId?: string;
    maxId?: string;
    minId?: string;
    onlyMedia?: boolean;
    remote?: boolean;
    local?: boolean;
    social?: boolean;
    any?: string[];
    all?: string[];
    none?: string[];
    pinned?: boolean | null;
    excludeReplies?: boolean | null;
    excludeReblogs?: boolean | null;
    tagged?: string | null;
    withMuted?: boolean;
} & __MisskeyTimelineOptions;
export type DriverTimelineGetApiResponse = Promise<MastoStatus[] | MegaStatus[] | Endpoints['notes/timeline']['res'] | Endpoints['notes/search-by-tag']['res'] | Endpoints['notes/user-list-timeline']['res'] | AppBskyFeedGetTimeline.Response | AppBskyFeedSearchPosts.OutputSchema>;
export interface TimelinesRoute {
    home(query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    public(query: DhaagaJsTimelineQueryOptions & {
        withReplies?: boolean | null;
    }): DriverTimelineGetApiResponse;
    publicAsGuest(urlLike: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    hashtag(q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    hashtagAsGuest(urlLike: string, q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
    list(q: string, query: DhaagaJsTimelineQueryOptions): DriverTimelineGetApiResponse;
}
export {};
//# sourceMappingURL=timelines.d.ts.map