import { LibraryPromise } from './_types.js';
import { MastoNotification } from '../../../../types/mastojs.types.js';
import { MegaNotification } from '../../../../types/megalodon.types.js';
import { Facet } from '@atproto/api';
import { DriverNotificationType, KNOWN_SOFTWARE } from '../../../../data/driver.js';
export type NotificationGetQueryDto = {
    limit: number;
    minId?: string;
    maxId?: string;
    accountId?: string;
    types?: DriverNotificationType[];
    excludeTypes?: DriverNotificationType[];
    markAsRead?: boolean;
    excludeType?: string[];
    includeType?: string[];
};
export type Pleroma_Notification_Type = '';
export interface NotificationsRoute {
    get(query: NotificationGetQueryDto): LibraryPromise<{
        data: MastoNotification[] | MegaNotification[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    getMentions(query: NotificationGetQueryDto): LibraryPromise<any>;
    getChats(driver: KNOWN_SOFTWARE): LibraryPromise<any>;
    getSocialUpdates(query: NotificationGetQueryDto): LibraryPromise<any>;
    getChat(roomId: string): LibraryPromise<any>;
    getMessages(roomId: string): LibraryPromise<any>;
    sendMessage(convoId: string, content: {
        text?: string;
        facets?: Facet[];
    }): LibraryPromise<any>;
}
//# sourceMappingURL=notifications.d.ts.map