import { errorBuilder, successWithData } from './dto/api-responses.dto.js';
import { ApiErrorCode } from '../../../types/result.types.js';
async function CommonErrorHandler(e) {
    if (e?.response?.data?.error?.code) {
        const code = e?.response?.data?.error?.code;
        return {
            statusCode: e?.response?.status,
            error: {
                code,
                message: code,
            },
        };
    }
    else if (e?.code) {
        return {
            error: {
                code: e.code,
                message: e.code,
            },
        };
    }
    else {
        console.log('[WARN]: new error', e);
        return {
            error: {
                code: ApiErrorCode.UNKNOWN_ERROR,
                message: e,
            },
        };
    }
}
export async function MastoErrorHandler(func, args) {
    try {
        return {
            data: args ? await func(...args) : await func(),
        };
    }
    catch (e) {
        return CommonErrorHandler(e);
    }
}
export async function MastojsHandler({ data, error, }) {
    try {
        const resData = await data;
        if (error || resData === undefined) {
            return errorBuilder(error);
        }
        return successWithData(data);
    }
    catch (e) {
        console.log(e);
        return errorBuilder(ApiErrorCode.UNKNOWN_ERROR);
    }
}
export async function PleromaErrorHandler(foo, func) {
    try {
        return {
            data: await func.bind(foo).apply(foo),
        };
    }
    catch (e) {
        return CommonErrorHandler(e);
    }
}
//# sourceMappingURL=_runner.js.map