import { EventEmitter } from 'eventemitter3';
import _ReconnectingWebSocket, { Options } from 'reconnecting-websocket';
import type { BroadcastEvents, Channels } from './streaming.types.js';
type ReconnectingWebSocket = _ReconnectingWebSocket.default;
export declare function urlQuery(obj: Record<string, string | number | boolean | undefined>): string;
type AnyOf<T extends Record<PropertyKey, unknown>> = T[keyof T];
export type StreamEvents = {
    _connected_: void;
    _disconnected_: void;
} & BroadcastEvents;
export interface IStream extends EventEmitter<StreamEvents> {
    state: 'initializing' | 'reconnecting' | 'connected';
    useChannel<C extends keyof Channels>(channel: C, params?: Channels[C]['params'], name?: string): IChannelConnection<Channels[C]>;
    removeSharedConnection(connection: SharedConnection): void;
    removeSharedConnectionPool(pool: Pool): void;
    disconnectToChannel(connection: NonSharedConnection): void;
    send(typeOrPayload: string): void;
    send(typeOrPayload: string, payload: unknown): void;
    send(typeOrPayload: Record<string, unknown> | unknown[]): void;
    send(typeOrPayload: string | Record<string, unknown> | unknown[], payload?: unknown): void;
    ping(): void;
    heartbeat(): void;
    close(): void;
}
export default class Stream extends EventEmitter<StreamEvents> implements IStream {
    private stream;
    state: 'initializing' | 'reconnecting' | 'connected';
    private sharedConnectionPools;
    private sharedConnections;
    private nonSharedConnections;
    private idCounter;
    constructor(origin: string, user: {
        token: string;
    } | null, options?: {
        WebSocket?: Options['WebSocket'];
        binaryType?: ReconnectingWebSocket['binaryType'];
    });
    private genId;
    useChannel<C extends keyof Channels>(channel: C, params?: Channels[C]['params'], name?: string): Connection<Channels[C]>;
    private useSharedConnection;
    removeSharedConnection(connection: SharedConnection): void;
    removeSharedConnectionPool(pool: Pool): void;
    private connectToChannel;
    disconnectToChannel(connection: NonSharedConnection): void;
    private onOpen;
    private onClose;
    private onMessage;
    send(typeOrPayload: string): void;
    send(typeOrPayload: string, payload: unknown): void;
    send(typeOrPayload: Record<string, unknown> | unknown[]): void;
    ping(): void;
    heartbeat(): void;
    close(): void;
}
declare class Pool {
    channel: string;
    id: string;
    protected stream: Stream;
    users: number;
    private disposeTimerId;
    private isConnected;
    constructor(stream: Stream, channel: string, id: string);
    private onStreamDisconnected;
    inc(): void;
    dec(): void;
    connect(): void;
    private disconnect;
}
export interface IChannelConnection<Channel extends AnyOf<Channels> = AnyOf<Channels>> extends EventEmitter<Channel['events']> {
    id: string;
    name?: string;
    inCount: number;
    outCount: number;
    channel: string;
    send<T extends keyof Channel['receives']>(type: T, body: Channel['receives'][T]): void;
    dispose(): void;
}
export declare abstract class Connection<Channel extends AnyOf<Channels> = AnyOf<Channels>> extends EventEmitter<Channel['events']> implements IChannelConnection<Channel> {
    channel: string;
    protected stream: Stream;
    abstract id: string;
    name?: string;
    inCount: number;
    outCount: number;
    constructor(stream: Stream, channel: string, name?: string);
    send<T extends keyof Channel['receives']>(type: T, body: Channel['receives'][T]): void;
    abstract dispose(): void;
}
declare class SharedConnection<Channel extends AnyOf<Channels> = AnyOf<Channels>> extends Connection<Channel> {
    private pool;
    get id(): string;
    constructor(stream: Stream, channel: string, pool: Pool, name?: string);
    dispose(): void;
}
declare class NonSharedConnection<Channel extends AnyOf<Channels> = AnyOf<Channels>> extends Connection<Channel> {
    id: string;
    protected params: Channel['params'];
    constructor(stream: Stream, channel: string, id: string, params: Channel['params']);
    connect(): void;
    dispose(): void;
}
export {};
//# sourceMappingURL=streaming.d.ts.map