const notificationTypes = [
  "note",
  "follow",
  "mention",
  "reply",
  "renote",
  "quote",
  "reaction",
  "pollEnded",
  "scheduledNotePosted",
  "scheduledNotePostFailed",
  "receiveFollowRequest",
  "followRequestAccepted",
  "app",
  "roleAssigned",
  "chatRoomInvitationReceived",
  "achievementEarned",
  "exportCompleted",
  "test",
  "login",
  "createToken"
];
const noteVisibilities = ["public", "home", "followers", "specified"];
const mutedNoteReasons = ["word", "manual", "spam", "other"];
const followingVisibilities = ["public", "followers", "private"];
const followersVisibilities = ["public", "followers", "private"];
const permissions = [
  "read:account",
  "write:account",
  "read:blocks",
  "write:blocks",
  "read:drive",
  "write:drive",
  "read:favorites",
  "write:favorites",
  "read:following",
  "write:following",
  "read:messaging",
  // deprecated
  "write:messaging",
  // deprecated
  "read:mutes",
  "write:mutes",
  "write:notes",
  "read:notifications",
  "write:notifications",
  "read:reactions",
  "write:reactions",
  "write:votes",
  "read:pages",
  "write:pages",
  "write:page-likes",
  "read:page-likes",
  "read:user-groups",
  "write:user-groups",
  "read:channels",
  "write:channels",
  "read:gallery",
  "write:gallery",
  "read:gallery-likes",
  "write:gallery-likes",
  "read:flash",
  "write:flash",
  "read:flash-likes",
  "write:flash-likes",
  "read:admin:abuse-user-reports",
  "write:admin:delete-account",
  "write:admin:delete-all-files-of-a-user",
  "read:admin:index-stats",
  "read:admin:table-stats",
  "read:admin:user-ips",
  "read:admin:meta",
  "write:admin:reset-password",
  "write:admin:resolve-abuse-user-report",
  "write:admin:send-email",
  "read:admin:server-info",
  "read:admin:show-moderation-log",
  "read:admin:show-user",
  "write:admin:suspend-user",
  "write:admin:unset-user-avatar",
  "write:admin:unset-user-banner",
  "write:admin:unsuspend-user",
  "write:admin:meta",
  "write:admin:user-note",
  "write:admin:roles",
  "read:admin:roles",
  "write:admin:relays",
  "read:admin:relays",
  "write:admin:invite-codes",
  "read:admin:invite-codes",
  "write:admin:announcements",
  "read:admin:announcements",
  "write:admin:avatar-decorations",
  "read:admin:avatar-decorations",
  "write:admin:federation",
  "write:admin:account",
  "read:admin:account",
  "write:admin:emoji",
  "read:admin:emoji",
  "write:admin:queue",
  "read:admin:queue",
  "write:admin:promo",
  "write:admin:drive",
  "read:admin:drive",
  "write:admin:ad",
  "read:admin:ad",
  "write:invite-codes",
  "read:invite-codes",
  "write:clip-favorite",
  "read:clip-favorite",
  "read:federation",
  "write:report-abuse",
  "write:chat",
  "read:chat"
];
const moderationLogTypes = [
  "updateServerSettings",
  "suspend",
  "unsuspend",
  "updateUserNote",
  "addCustomEmoji",
  "updateCustomEmoji",
  "deleteCustomEmoji",
  "assignRole",
  "unassignRole",
  "createRole",
  "updateRole",
  "deleteRole",
  "clearQueue",
  "promoteQueue",
  "deleteDriveFile",
  "deleteNote",
  "createGlobalAnnouncement",
  "createUserAnnouncement",
  "updateGlobalAnnouncement",
  "updateUserAnnouncement",
  "deleteGlobalAnnouncement",
  "deleteUserAnnouncement",
  "resetPassword",
  "suspendRemoteInstance",
  "unsuspendRemoteInstance",
  "updateRemoteInstanceNote",
  "markSensitiveDriveFile",
  "unmarkSensitiveDriveFile",
  "resolveAbuseReport",
  "forwardAbuseReport",
  "updateAbuseReportNote",
  "createInvitation",
  "createAd",
  "updateAd",
  "deleteAd",
  "createAvatarDecoration",
  "updateAvatarDecoration",
  "deleteAvatarDecoration",
  "unsetUserAvatar",
  "unsetUserBanner",
  "createSystemWebhook",
  "updateSystemWebhook",
  "deleteSystemWebhook",
  "createAbuseReportNotificationRecipient",
  "updateAbuseReportNotificationRecipient",
  "deleteAbuseReportNotificationRecipient",
  "deleteAccount",
  "deletePage",
  "deleteFlash",
  "deleteGalleryPost",
  "deleteChatRoom",
  "updateProxyAccountDescription"
];
const rolePolicies = [
  "gtlAvailable",
  "ltlAvailable",
  "canPublicNote",
  "mentionLimit",
  "canInvite",
  "inviteLimit",
  "inviteLimitCycle",
  "inviteExpirationTime",
  "canManageCustomEmojis",
  "canManageAvatarDecorations",
  "canSearchNotes",
  "canSearchUsers",
  "canUseTranslator",
  "canHideAds",
  "driveCapacityMb",
  "maxFileSizeMb",
  "alwaysMarkNsfw",
  "canUpdateBioMedia",
  "pinLimit",
  "antennaLimit",
  "wordMuteLimit",
  "webhookLimit",
  "clipLimit",
  "noteEachClipsLimit",
  "userListLimit",
  "userEachUserListsLimit",
  "rateLimitFactor",
  "avatarDecorationLimit",
  "canImportAntennas",
  "canImportBlocking",
  "canImportFollowing",
  "canImportMuting",
  "canImportUserLists",
  "chatAvailability",
  "uploadableFileTypes",
  "noteDraftLimit",
  "scheduledNoteLimit",
  "watermarkAvailable"
];
const queueTypes = [
  "system",
  "endedPollNotification",
  "postScheduledNote",
  "deliver",
  "inbox",
  "db",
  "relationship",
  "objectStorage",
  "userWebhookDeliver",
  "systemWebhookDeliver"
];
const reversiUpdateKeys = [
  "map",
  "bw",
  "isLlotheo",
  "canPutEverywhere",
  "loopedBoard",
  "timeLimitForEachTurn"
];
export {
  followersVisibilities,
  followingVisibilities,
  moderationLogTypes,
  mutedNoteReasons,
  noteVisibilities,
  notificationTypes,
  permissions,
  queueTypes,
  reversiUpdateKeys,
  rolePolicies
};
//# sourceMappingURL=consts.js.map
