import Response from '../response.js';
import PixelfedEntity from './entity.js';
import MegalodonEntity from '../entity.js';
import { UnknownNotificationTypeError } from '../notification.js';
import Streaming from './web_socket.js';
declare namespace PixelfedAPI {
    interface Interface {
        get<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }, pathIsFullyQualified?: boolean): Promise<Response<T>>;
        put<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        putForm<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        patch<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        patchForm<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        post<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        postForm<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        del<T = any>(path: string, params?: any, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        cancel(): void;
        socket(): Streaming;
    }
    class Client implements Interface {
        static DEFAULT_SCOPE: string[];
        static DEFAULT_URL: string;
        static NO_REDIRECT: string;
        private accessToken;
        private baseUrl;
        private abortController;
        constructor(baseUrl: string, accessToken?: string | null, _userAgent?: string);
        get<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }, pathIsFullyQualified?: boolean): Promise<Response<T>>;
        put<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        putForm<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        patch<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        patchForm<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        post<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        postForm<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        del<T>(path: string, params?: {}, headers?: {
            [key: string]: string;
        }): Promise<Response<T>>;
        cancel(): void;
        socket(): Streaming;
    }
    namespace Entity {
        type Account = PixelfedEntity.Account;
        type Announcement = PixelfedEntity.Announcement;
        type Application = PixelfedEntity.Application;
        type AsyncAttachment = MegalodonEntity.AsyncAttachment;
        type Attachment = PixelfedEntity.Attachment;
        type Context = PixelfedEntity.Context;
        type Conversation = PixelfedEntity.Conversation;
        type Emoji = PixelfedEntity.Emoji;
        type Field = PixelfedEntity.Field;
        type Filter = PixelfedEntity.Filter;
        type History = PixelfedEntity.History;
        type Instance = PixelfedEntity.Instance;
        type Marker = PixelfedEntity.Marker;
        type Mention = PixelfedEntity.Mention;
        type Notification = PixelfedEntity.Notification;
        type Poll = PixelfedEntity.Poll;
        type PollOption = PixelfedEntity.PollOption;
        type Preferences = PixelfedEntity.Preferences;
        type Relationship = PixelfedEntity.Relationship;
        type Report = PixelfedEntity.Report;
        type Results = PixelfedEntity.Results;
        type ScheduledStatus = PixelfedEntity.ScheduledStatus;
        type Source = PixelfedEntity.Source;
        type Stats = PixelfedEntity.Stats;
        type Status = PixelfedEntity.Status;
        type StatusVisibility = PixelfedEntity.StatusVisibility;
        type StatusParams = PixelfedEntity.StatusParams;
        type Tag = PixelfedEntity.Tag;
        type Token = PixelfedEntity.Token;
    }
    namespace Converter {
        const encodeNotificationType: (t: MegalodonEntity.NotificationType) => PixelfedEntity.NotificationType | UnknownNotificationTypeError;
        const decodeNotificationType: (t: PixelfedEntity.NotificationType) => MegalodonEntity.NotificationType | UnknownNotificationTypeError;
        const visibility: (v: PixelfedAPI.Entity.StatusVisibility) => MegalodonEntity.StatusVisibility;
        const encodeVisibility: (v: MegalodonEntity.StatusVisibility) => PixelfedAPI.Entity.StatusVisibility;
        const account: (a: Entity.Account) => MegalodonEntity.Account;
        const announcement: (a: Entity.Announcement) => MegalodonEntity.Announcement;
        const application: (a: Entity.Application) => MegalodonEntity.Application;
        const attachment: (a: Entity.Attachment) => MegalodonEntity.Attachment;
        const async_attachment: (a: Entity.AsyncAttachment) => import("../entities/attachment.js").Attachment | import("../entities/async_attachment.js").AsyncAttachment;
        const context: (c: Entity.Context) => MegalodonEntity.Context;
        const conversation: (c: Entity.Conversation) => MegalodonEntity.Conversation;
        const emoji: (e: Entity.Emoji) => MegalodonEntity.Emoji;
        const field: (f: Entity.Field) => MegalodonEntity.Field;
        const filter: (f: Entity.Filter) => MegalodonEntity.Filter;
        const history: (h: Entity.History) => MegalodonEntity.History;
        const instance: (i: Entity.Instance) => MegalodonEntity.Instance;
        const marker: (m: Entity.Marker | Record<never, never>) => MegalodonEntity.Marker | Record<never, never>;
        const mention: (m: Entity.Mention) => MegalodonEntity.Mention;
        const notification: (n: Entity.Notification) => MegalodonEntity.Notification | UnknownNotificationTypeError;
        const poll: (p: Entity.Poll) => MegalodonEntity.Poll;
        const poll_option: (p: Entity.PollOption) => MegalodonEntity.PollOption;
        const preferences: (p: Entity.Preferences) => MegalodonEntity.Preferences;
        const relationship: (r: Entity.Relationship) => MegalodonEntity.Relationship;
        const report: (r: Entity.Report) => MegalodonEntity.Report;
        const results: (r: Entity.Results) => MegalodonEntity.Results;
        const scheduled_status: (s: Entity.ScheduledStatus) => MegalodonEntity.ScheduledStatus;
        const source: (s: Entity.Source) => MegalodonEntity.Source;
        const stats: (s: Entity.Stats) => MegalodonEntity.Stats;
        const status: (s: Entity.Status) => MegalodonEntity.Status;
        const status_params: (s: Entity.StatusParams) => MegalodonEntity.StatusParams;
        const tag: (t: Entity.Tag) => MegalodonEntity.Tag;
        const token: (t: Entity.Token) => MegalodonEntity.Token;
    }
}
export default PixelfedAPI;
