export function parseLinkHeader(header) {
    const links = {};
    if (header.length === 0) {
        throw new Error('input must not be of zero length');
    }
    const parts = header.split(',');
    parts.forEach(part => {
        const section = part.split(';');
        if (section.length !== 2) {
            throw new Error("section could not be split on ';'");
        }
        const url = section[0].replace(/<(.*)>/, '$1').trim();
        const name = section[1].replace(/rel="(.*)"/, '$1').trim();
        links[name] = url;
    });
    return links;
}
