import axios from 'axios';
import { NodeinfoError } from './megalodon.js';
const NODEINFO_10 = 'http://nodeinfo.diaspora.software/ns/schema/1.0';
const NODEINFO_20 = 'http://nodeinfo.diaspora.software/ns/schema/2.0';
const NODEINFO_21 = 'http://nodeinfo.diaspora.software/ns/schema/2.1';
export const detector = async (url) => {
    const options = {
        timeout: 20000
    };
    const res = await axios.get(url + '/.well-known/nodeinfo', options);
    const link = res.data.links.find(l => l.rel === NODEINFO_20 || l.rel === NODEINFO_21);
    if (!link)
        throw new NodeinfoError('Could not find nodeinfo');
    switch (link.rel) {
        case NODEINFO_10: {
            const res = await axios.get(link.href, options);
            switch (res.data.software.name) {
                case 'akkoma':
                    return 'pleroma';
                case 'firefish':
                    return 'firefish';
                case 'friendica':
                    return 'friendica';
                case 'gotosocial':
                    return 'gotosocial';
                case 'hometown':
                    return 'mastodon';
                case 'iceshrimp':
                    return 'firefish';
                case 'mastodon':
                    return 'mastodon';
                case 'pixelfed':
                    return 'pixelfed';
                case 'pleroma':
                    return 'pleroma';
                case 'sharkey':
                    return 'mastodon';
                default:
                    if (res.data.metadata.upstream?.name && res.data.metadata.upstream.name.toLowerCase() === 'mastodon') {
                        return 'mastodon';
                    }
                    throw new NodeinfoError('Unknown SNS');
            }
        }
        case NODEINFO_20: {
            const res = await axios.get(link.href, options);
            switch (res.data.software.name) {
                case 'akkoma':
                    return 'pleroma';
                case 'firefish':
                    return 'firefish';
                case 'friendica':
                    return 'friendica';
                case 'gotosocial':
                    return 'gotosocial';
                case 'hometown':
                    return 'mastodon';
                case 'iceshrimp':
                    return 'firefish';
                case 'mastodon':
                    return 'mastodon';
                case 'pixelfed':
                    return 'pixelfed';
                case 'pleroma':
                    return 'pleroma';
                case 'sharkey':
                    return 'mastodon';
                default:
                    if (res.data.metadata.upstream?.name && res.data.metadata.upstream.name.toLowerCase() === 'mastodon') {
                        return 'mastodon';
                    }
                    throw new NodeinfoError('Unknown SNS');
            }
        }
        case NODEINFO_21: {
            const res = await axios.get(link.href, options);
            switch (res.data.software.name) {
                case 'akkoma':
                    return 'pleroma';
                case 'firefish':
                    return 'firefish';
                case 'friendica':
                    return 'friendica';
                case 'gotosocial':
                    return 'gotosocial';
                case 'hometown':
                    return 'mastodon';
                case 'iceshrimp':
                    return 'firefish';
                case 'mastodon':
                    return 'mastodon';
                case 'pixelfed':
                    return 'pixelfed';
                case 'pleroma':
                    return 'pleroma';
                case 'sharkey':
                    return 'mastodon';
                default:
                    if (res.data.metadata.upstream?.name && res.data.metadata.upstream.name.toLowerCase() === 'mastodon') {
                        return 'mastodon';
                    }
                    throw new NodeinfoError('Unknown SNS');
            }
        }
        default:
            throw new NodeinfoError('Could not find nodeinfo');
    }
};
