export class WebSocketSubscriptionCounterImpl {
    counts = new Map();
    count(stream, params) {
        const key = this.hash(stream, params);
        return this.counts.get(key) ?? 0;
    }
    increment(stream, params) {
        const key = this.hash(stream, params);
        if (!this.counts.has(key)) {
            this.counts.set(key, 0);
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        this.counts.set(key, this.counts.get(key) + 1);
    }
    decrement(stream, params) {
        const key = this.hash(stream, params);
        if (!this.counts.has(key)) {
            throw new Error("Cannot decrement non-existent count");
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        this.counts.set(key, this.counts.get(key) - 1);
    }
    hash(stream, params) {
        return JSON.stringify({ stream, params });
    }
}
