import WebSocket from "isomorphic-ws";
export function waitForOpen(ws) {
    if (ws.readyState === WebSocket.OPEN) {
        return Promise.resolve();
    }
    return new Promise((resolve, reject) => {
        const handleError = (error) => {
            reject(error);
        };
        const handleClose = () => {
            reject(new Error("WebSocket closed"));
        };
        const handleOpen = () => {
            resolve();
        };
        ws.addEventListener("error", handleError, { once: true });
        ws.addEventListener("close", handleClose, { once: true });
        ws.addEventListener("open", handleOpen, { once: true });
    });
}
export function waitForClose(ws) {
    if (ws.readyState === WebSocket.CLOSED) {
        return Promise.resolve();
    }
    return new Promise((resolve) => {
        const handleClose = () => {
            resolve();
        };
        ws.addEventListener("error", handleClose, { once: true });
        ws.addEventListener("close", handleClose, { once: true });
    });
}
