export class BaseHttp {
    get(path, data, meta = {}) {
        return this.request({
            method: "GET",
            path,
            search: data,
            ...meta,
        });
    }
    post(path, data, meta = {}) {
        return this.request({
            method: "POST",
            path,
            body: data,
            ...meta,
        });
    }
    delete(path, data, meta = {}) {
        return this.request({
            method: "DELETE",
            path,
            body: data,
            ...meta,
        });
    }
    put(path, data, meta = {}) {
        return this.request({
            method: "PUT",
            path,
            body: data,
            ...meta,
        });
    }
    patch(path, data, meta = {}) {
        return this.request({
            method: "PATCH",
            path,
            body: data,
            ...meta,
        });
    }
}
