import { type HttpConfig, type Serializer } from "../../interfaces/index.js";
export interface MastoHttpConfigProps {
    /**
     * REST API URL for your Mastodon instance.
     */
    readonly url: string;
    /**
     * Access token for the REST API.
     *
     * Please refer to the [quickstart](https://github.com/neet/masto.js?tab=readme-ov-file#quick-start) for how to get an access token.
     */
    readonly accessToken?: string;
    /**
     * Timeout milliseconds for the fetch request.
     *
     * Defaults to browser's default timeout.
     */
    readonly timeout?: number;
    /**
     * Additional options for the `fetch` function.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/fetch
     */
    readonly requestInit?: Omit<RequestInit, "body" | "method">;
}
export declare class HttpConfigImpl implements HttpConfig {
    private readonly props;
    private readonly serializer;
    constructor(props: MastoHttpConfigProps, serializer: Serializer);
    mergeRequestInitWithDefaults(override?: RequestInit): RequestInit;
    resolvePath(path: string, params?: string | Record<string, unknown>): URL;
    private mergeHeadersWithDefaults;
    private mergeAbortSignalWithDefaults;
}
