import { HttpActionDispatcherHookMastodon } from "./action/dispatcher-http-hook-mastodon.js";
import { createActionProxy, HttpActionDispatcher, WebSocketActionDispatcher, } from "./action/index.js";
import { HttpConfigImpl, WebSocketConfigImpl, } from "./config/index.js";
import { HttpNativeImpl } from "./http/index.js";
import { createLogger } from "./logger/index.js";
import { SerializerNativeImpl } from "./serializers/index.js";
import { WebSocketConnectorImpl, WebSocketSubscriptionCounterImpl, } from "./ws/index.js";
export const createRestAPIClient = (props) => {
    const serializer = new SerializerNativeImpl();
    const config = new HttpConfigImpl(props, serializer);
    const logger = createLogger(props.log);
    const http = new HttpNativeImpl(serializer, config, logger);
    const hook = new HttpActionDispatcherHookMastodon(http, props.mediaTimeout);
    const actionDispatcher = new HttpActionDispatcher(http, hook);
    const actionProxy = createActionProxy(actionDispatcher, {
        context: ["api"],
    });
    return actionProxy;
};
export const createOAuthAPIClient = (props) => {
    const serializer = new SerializerNativeImpl();
    const config = new HttpConfigImpl(props, serializer);
    const logger = createLogger(props.log);
    const http = new HttpNativeImpl(serializer, config, logger);
    const hook = new HttpActionDispatcherHookMastodon(http);
    const actionDispatcher = new HttpActionDispatcher(http, hook);
    const actionProxy = createActionProxy(actionDispatcher, {
        context: ["oauth"],
    });
    return actionProxy;
};
export function createStreamingAPIClient(props) {
    const serializer = new SerializerNativeImpl();
    const config = new WebSocketConfigImpl(props, serializer);
    const logger = createLogger(props.log);
    const connector = new WebSocketConnectorImpl({
        constructorParameters: [
            config.resolvePath("/api/v1/streaming"),
            config.getProtocols(),
        ],
        implementation: props.implementation,
        maxAttempts: config.getMaxAttempts(),
    }, logger);
    const counter = new WebSocketSubscriptionCounterImpl();
    const actionDispatcher = new WebSocketActionDispatcher(connector, counter, serializer, logger);
    const actionProxy = createActionProxy(actionDispatcher);
    return actionProxy;
}
