import { MastoUnexpectedError } from "../errors/index.js";
import { WebSocketSubscription } from "../ws/index.js";
export class WebSocketActionDispatcher {
    connector;
    counter;
    serializer;
    logger;
    constructor(connector, counter, serializer, logger) {
        this.connector = connector;
        this.counter = counter;
        this.serializer = serializer;
        this.logger = logger;
    }
    dispatch(action) {
        if (action.type === "close") {
            this.connector.kill();
            return {};
        }
        if (action.type === "prepare") {
            return this.connector.acquire();
        }
        if (action.type !== "subscribe") {
            throw new MastoUnexpectedError(`Unknown action type ${action.type}`);
        }
        const data = action.data ?? {};
        const stream = action.path.replace(/^\//, "").replaceAll("/", ":");
        return new WebSocketSubscription(this.connector, this.counter, this.serializer, stream, this.logger, { ...data });
    }
    [Symbol.dispose]() {
        this.connector.kill();
    }
}
