import { type Action, type ActionDispatcher, type ActionDispatcherHook, type Http } from "../../interfaces/index.js";
export type HttpActionType = "fetch" | "create" | "update" | "remove" | "list";
export type HttpAction = Action<HttpActionType>;
export declare class HttpActionDispatcher implements ActionDispatcher<HttpAction> {
    private readonly http;
    private readonly hook;
    constructor(http: Http, hook: ActionDispatcherHook<HttpAction>);
    dispatch<T>(action: HttpAction): T | Promise<T>;
}
