import WebSocket from "isomorphic-ws";
import { type Logger, type WebSocketConnector } from "../../interfaces/index.js";
interface WebSocketConnectorImplProps {
    readonly constructorParameters: ConstructorParameters<typeof WebSocket>;
    readonly implementation?: unknown;
    readonly maxAttempts?: number;
}
export declare class WebSocketConnectorImpl implements WebSocketConnector {
    private readonly props;
    private readonly logger?;
    private ws?;
    private killed;
    private queue;
    private backoff;
    constructor(props: WebSocketConnectorImplProps, logger?: Logger | undefined);
    acquire(): Promise<WebSocket>;
    [Symbol.asyncIterator](): AsyncIterableIterator<WebSocket>;
    kill(): void;
    private spawn;
}
export {};
