"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForOpen = waitForOpen;
exports.waitForClose = waitForClose;
const isomorphic_ws_1 = __importDefault(require("isomorphic-ws"));
function waitForOpen(ws) {
    if (ws.readyState === isomorphic_ws_1.default.OPEN) {
        return Promise.resolve();
    }
    return new Promise((resolve, reject) => {
        const handleError = (error) => {
            reject(error);
        };
        const handleClose = () => {
            reject(new Error("WebSocket closed"));
        };
        const handleOpen = () => {
            resolve();
        };
        ws.addEventListener("error", handleError, { once: true });
        ws.addEventListener("close", handleClose, { once: true });
        ws.addEventListener("open", handleOpen, { once: true });
    });
}
function waitForClose(ws) {
    if (ws.readyState === isomorphic_ws_1.default.CLOSED) {
        return Promise.resolve();
    }
    return new Promise((resolve) => {
        const handleClose = () => {
            resolve();
        };
        ws.addEventListener("error", handleClose, { once: true });
        ws.addEventListener("close", handleClose, { once: true });
    });
}
