"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerializerNativeImpl = void 0;
const change_case_1 = require("change-case");
const index_js_1 = require("../errors/index.js");
const flatten_js_1 = require("./flatten.js");
const transform_keys_js_1 = require("./transform-keys.js");
class SerializerNativeImpl {
    serialize(type, rawData) {
        const data = (0, transform_keys_js_1.transformKeys)(rawData, change_case_1.snakeCase);
        switch (type) {
            case "json": {
                return JSON.stringify(data);
            }
            case "multipart-form": {
                const formData = new FormData();
                for (const [key, value] of Object.entries((0, flatten_js_1.flattenForFormData)(data))) {
                    formData.append(key, value);
                }
                return formData;
            }
            case "querystring": {
                return (0, flatten_js_1.flattenForRailsQueryString)(data);
            }
            default: {
                throw new index_js_1.MastoUnexpectedError(`Unknown content type ${type} to serialize.`);
            }
        }
    }
    deserialize(type, data) {
        switch (type) {
            case "json": {
                try {
                    return (0, transform_keys_js_1.transformKeys)(JSON.parse(data), change_case_1.camelCase);
                }
                catch {
                    throw new index_js_1.MastoDeserializeError(`Malformed JSON ${data} returned from the server.`, type, data);
                }
            }
            default: {
                throw new index_js_1.MastoDeserializeError(`Unknown content type ${type} returned from the server.`, type, data);
            }
        }
    }
}
exports.SerializerNativeImpl = SerializerNativeImpl;
