"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEncoding = void 0;
const getEncoding = (headers) => {
    const contentType = headers.get("Content-Type")?.replace(/\s*;.*$/, "");
    if (typeof contentType !== "string") {
        return;
    }
    switch (contentType) {
        case "application/json": {
            return "json";
        }
        case "multipart/form-data": {
            return "multipart-form";
        }
        default: {
            return;
        }
    }
};
exports.getEncoding = getEncoding;
