"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketConfigImpl = void 0;
class WebSocketConfigImpl {
    props;
    serializer;
    constructor(props, serializer) {
        this.props = props;
        this.serializer = serializer;
    }
    getProtocols(protocols = []) {
        if (this.props.useInsecureAccessToken ||
            this.props.accessToken == undefined) {
            return [...protocols];
        }
        return [this.props.accessToken, ...protocols];
    }
    resolvePath(path, params = {}) {
        const url = new URL(path, this.props.streamingApiUrl);
        if (this.props.useInsecureAccessToken) {
            params.accessToken = this.props.accessToken;
        }
        url.search = this.serializer.serialize("querystring", params);
        return url;
    }
    getMaxAttempts() {
        if (this.props.retry === true || this.props.retry == undefined) {
            return Number.POSITIVE_INFINITY;
        }
        if (this.props.retry === false) {
            return 1;
        }
        return this.props.retry;
    }
}
exports.WebSocketConfigImpl = WebSocketConfigImpl;
