"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeHeadersInit = void 0;
const mergeHeadersInit = ([head, ...tail]) => {
    const headers = new Headers(head);
    for (const entry of tail) {
        for (const [key, value] of new Headers(entry).entries()) {
            headers.set(key, value);
        }
    }
    return headers;
};
exports.mergeHeadersInit = mergeHeadersInit;
