"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpConfigImpl = void 0;
const merge_headers_init_js_1 = require("./merge-headers-init.js");
class HttpConfigImpl {
    props;
    serializer;
    constructor(props, serializer) {
        this.props = props;
        this.serializer = serializer;
    }
    mergeRequestInitWithDefaults(override = {}) {
        const requestInit = { ...this.props.requestInit };
        // Merge
        {
            const { headers, signal, ...rest } = override;
            Object.assign(requestInit, rest);
            requestInit.headers = this.mergeHeadersWithDefaults(headers);
            requestInit.signal = this.mergeAbortSignalWithDefaults(signal);
        }
        return requestInit;
    }
    resolvePath(path, params) {
        const url = new URL(path, this.props.url);
        if (typeof params === "string") {
            url.search = params;
        }
        else if (params) {
            url.search = this.serializer.serialize("querystring", params);
        }
        return url;
    }
    mergeHeadersWithDefaults(override = {}) {
        const headersInit = (0, merge_headers_init_js_1.mergeHeadersInit)([
            this.props.requestInit?.headers ?? {},
            override,
        ]);
        const headers = new Headers(headersInit);
        if (this.props.accessToken) {
            headers.set("Authorization", `Bearer ${this.props.accessToken}`);
        }
        return new Headers(headers);
    }
    mergeAbortSignalWithDefaults(signal) {
        const signals = [];
        if (this.props.timeout) {
            signals.push(AbortSignal.timeout(this.props.timeout));
        }
        if (this.props.requestInit?.signal) {
            signals.push(this.props.requestInit.signal);
        }
        if (signal) {
            signals.push(signal);
        }
        return AbortSignal.any(signals);
    }
}
exports.HttpConfigImpl = HttpConfigImpl;
