"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpActionDispatcher = void 0;
const paginator_http_js_1 = require("./paginator-http.js");
class HttpActionDispatcher {
    http;
    hook;
    constructor(http, hook) {
        this.http = http;
        this.hook = hook;
    }
    dispatch(action) {
        if (this.hook) {
            action = this.hook.beforeDispatch(action);
        }
        let result = this.hook.dispatch(action);
        if (result !== false) {
            return result;
        }
        switch (action.type) {
            case "fetch": {
                result = this.http
                    .get(action.path, action.data, action.meta)
                    .then((r) => (action.raw ? r : r.data));
                break;
            }
            case "create": {
                result = this.http
                    .post(action.path, action.data, action.meta)
                    .then((r) => (action.raw ? r : r.data));
                break;
            }
            case "update": {
                result = this.http
                    .put(action.path, action.data, action.meta)
                    .then((r) => (action.raw ? r : r.data));
                break;
            }
            case "remove": {
                result = this.http
                    .delete(action.path, action.data, action.meta)
                    .then((r) => (action.raw ? r : r.data));
                break;
            }
            case "list": {
                result = new paginator_http_js_1.PaginatorHttp(this.http, action.raw, action.path, action.data);
                break;
            }
        }
        /* eslint-disable unicorn/prefer-ternary, prettier/prettier */
        if (result instanceof Promise) {
            return result.then((result) => this.hook?.afterDispatch(action, result));
        }
        else {
            return this.hook.afterDispatch(action, result);
        }
        /* eslint-enable unicorn/prefer-ternary, prettier/prettier */
    }
}
exports.HttpActionDispatcher = HttpActionDispatcher;
