"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuth2HttpError = exports.OAuth2Error = void 0;
/**
 * An error class for any error the server emits.
 *
 * The 'oauth2Code' property will have the oauth2 error type,
 * such as:
 * - invalid_request
 * - invalid_client
 * - invalid_grant
 * - unauthorized_client
 * - unsupported_grant_type
 * - invalid_scope
 */
class OAuth2Error extends Error {
    constructor(message, oauth2Code) {
        super(message);
        this.oauth2Code = oauth2Code;
    }
}
exports.OAuth2Error = OAuth2Error;
/**
 * A OAuth2 error that was emitted as a HTTP error
 *
 * The 'code' property will have the oauth2 error type,
 * such as:
 * - invalid_request
 * - invalid_client
 * - invalid_grant
 * - unauthorized_client
 * - unsupported_grant_type
 * - invalid_scope
 *
 * This Error also gives you access to the HTTP status code and response body.
 */
class OAuth2HttpError extends OAuth2Error {
    constructor(message, oauth2Code, response, parsedBody) {
        super(message, oauth2Code);
        this.httpCode = response.status;
        this.response = response;
        this.parsedBody = parsedBody;
    }
}
exports.OAuth2HttpError = OAuth2HttpError;
//# sourceMappingURL=error.js.map