"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTidError = exports.isValidTid = exports.ensureValidTid = void 0;
const TID_LENGTH = 13;
const TID_REGEX = /^[234567abcdefghij][234567abcdefghijklmnopqrstuvwxyz]{12}$/;
const ensureValidTid = (tid) => {
    if (tid.length !== TID_LENGTH) {
        throw new InvalidTidError(`TID must be ${TID_LENGTH} characters`);
    }
    // simple regex to enforce most constraints via just regex and length.
    if (!TID_REGEX.test(tid)) {
        throw new InvalidTidError('TID syntax not valid (regex)');
    }
};
exports.ensureValidTid = ensureValidTid;
const isValidTid = (tid) => {
    return tid.length === TID_LENGTH && TID_REGEX.test(tid);
};
exports.isValidTid = isValidTid;
class InvalidTidError extends Error {
}
exports.InvalidTidError = InvalidTidError;
//# sourceMappingURL=tid.js.map