"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidRecordKeyError = exports.isValidRecordKey = exports.ensureValidRecordKey = void 0;
const ensureValidRecordKey = (rkey) => {
    if (rkey.length > 512 || rkey.length < 1) {
        throw new InvalidRecordKeyError('record key must be 1 to 512 characters');
    }
    // simple regex to enforce most constraints via just regex and length.
    if (!/^[a-zA-Z0-9_~.:-]{1,512}$/.test(rkey)) {
        throw new InvalidRecordKeyError('record key syntax not valid (regex)');
    }
    if (rkey === '.' || rkey === '..')
        throw new InvalidRecordKeyError('record key can not be "." or ".."');
};
exports.ensureValidRecordKey = ensureValidRecordKey;
const isValidRecordKey = (rkey) => {
    try {
        (0, exports.ensureValidRecordKey)(rkey);
    }
    catch (err) {
        if (err instanceof InvalidRecordKeyError) {
            return false;
        }
        throw err;
    }
    return true;
};
exports.isValidRecordKey = isValidRecordKey;
class InvalidRecordKeyError extends Error {
}
exports.InvalidRecordKeyError = InvalidRecordKeyError;
//# sourceMappingURL=recordkey.js.map