export declare class NSID {
    readonly segments: readonly string[];
    static parse(input: string): NSID;
    static create(authority: string, name: string): NSID;
    static isValid(nsid: string): boolean;
    static from(input: {
        toString: () => string;
    }): NSID;
    constructor(nsid: string);
    get authority(): string;
    get name(): string | undefined;
    toString(): string;
}
export declare function ensureValidNsid(nsid: string): void;
export declare function parseNsid(nsid: string): string[];
export declare function isValidNsid(nsid: string): boolean;
type ValidateResult<T> = {
    success: true;
    value: T;
} | {
    success: false;
    message: string;
};
export declare function validateNsid(input: string): ValidateResult<string[]>;
/**
 * @deprecated Use {@link ensureValidNsid} if you care about error details,
 * {@link parseNsid}/{@link NSID.parse} if you need the parsed segments, or
 * {@link isValidNsid} if you just want a boolean.
 */
export declare function ensureValidNsidRegex(nsid: string): void;
/**
 * Regexp based validation that behaves identically to the previous code but
 * provides less detailed error messages (while being 20% to 50% faster).
 */
export declare function validateNsidRegex(value: string): ValidateResult<string>;
export declare class InvalidNsidError extends Error {
}
export {};
//# sourceMappingURL=nsid.d.ts.map